package cdm.product.template.validation;

import cdm.product.template.AmericanExercise;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class AmericanExerciseTypeFormatValidator implements Validator<AmericanExercise> {

	@Override
	public ValidationResult<AmericanExercise> validate(RosettaPath path, AmericanExercise o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("AmericanExercise", ValidationType.TYPE_FORMAT, "AmericanExercise", path, "", error);
		}
		return success("AmericanExercise", ValidationType.TYPE_FORMAT, "AmericanExercise", path, "");
	}

}
