package cdm.product.common.settlement.validation;

import cdm.product.common.settlement.PrincipalPaymentSchedule;
import cdm.product.common.settlement.PrincipalPayments;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class PrincipalPaymentsValidator implements Validator<PrincipalPayments> {

	@Override
	public ValidationResult<PrincipalPayments> validate(RosettaPath path, PrincipalPayments o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("initialPayment", (Boolean) o.getInitialPayment() != null ? 1 : 0, 1, 1), 
				checkCardinality("finalPayment", (Boolean) o.getFinalPayment() != null ? 1 : 0, 1, 1), 
				checkCardinality("intermediatePayment", (Boolean) o.getIntermediatePayment() != null ? 1 : 0, 1, 1), 
				checkCardinality("principalPaymentSchedule", (PrincipalPaymentSchedule) o.getPrincipalPaymentSchedule() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("PrincipalPayments", ValidationType.CARDINALITY, "PrincipalPayments", path, "", error);
		}
		return success("PrincipalPayments", ValidationType.CARDINALITY, "PrincipalPayments", path, "");
	}

}
