package cdm.product.common.settlement.validation;

import cdm.observable.asset.CashPrice;
import cdm.observable.asset.PriceExpressionEnum;
import cdm.product.common.settlement.CashflowType;
import cdm.product.common.settlement.ScheduledTransferEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CashflowTypeValidator implements Validator<CashflowType> {

	@Override
	public ValidationResult<CashflowType> validate(RosettaPath path, CashflowType o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("cashflowType", (ScheduledTransferEnum) o.getCashflowType() != null ? 1 : 0, 0, 1), 
				checkCardinality("cashPrice", (CashPrice) o.getCashPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceExpression", (PriceExpressionEnum) o.getPriceExpression() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CashflowType", ValidationType.CARDINALITY, "CashflowType", path, "", error);
		}
		return success("CashflowType", ValidationType.CARDINALITY, "CashflowType", path, "");
	}

}
