package cdm.product.common.schedule.validation;

import cdm.product.asset.StubValue;
import cdm.product.common.schedule.StubCalculationPeriodAmount;
import cdm.product.common.schedule.metafields.ReferenceWithMetaCalculationPeriodDates;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class StubCalculationPeriodAmountValidator implements Validator<StubCalculationPeriodAmount> {

	@Override
	public ValidationResult<StubCalculationPeriodAmount> validate(RosettaPath path, StubCalculationPeriodAmount o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("calculationPeriodDatesReference", (ReferenceWithMetaCalculationPeriodDates) o.getCalculationPeriodDatesReference() != null ? 1 : 0, 1, 1), 
				checkCardinality("initialStub", (StubValue) o.getInitialStub() != null ? 1 : 0, 0, 1), 
				checkCardinality("finalStub", (StubValue) o.getFinalStub() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("StubCalculationPeriodAmount", ValidationType.CARDINALITY, "StubCalculationPeriodAmount", path, "", error);
		}
		return success("StubCalculationPeriodAmount", ValidationType.CARDINALITY, "StubCalculationPeriodAmount", path, "");
	}

}
