package cdm.product.collateral.validation;

import cdm.product.collateral.CollateralProvisions;
import cdm.product.collateral.CollateralTypeEnum;
import cdm.product.collateral.SubstitutionProvisions;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CollateralProvisionsValidator implements Validator<CollateralProvisions> {

	@Override
	public ValidationResult<CollateralProvisions> validate(RosettaPath path, CollateralProvisions o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("collateralType", (CollateralTypeEnum) o.getCollateralType() != null ? 1 : 0, 1, 1), 
				checkCardinality("substitutionProvisions", (SubstitutionProvisions) o.getSubstitutionProvisions() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CollateralProvisions", ValidationType.CARDINALITY, "CollateralProvisions", path, "", error);
		}
		return success("CollateralProvisions", ValidationType.CARDINALITY, "CollateralProvisions", path, "");
	}

}
