package cdm.product.collateral.validation;

import cdm.base.datetime.Period;
import cdm.product.collateral.AverageTradingVolume;
import cdm.product.collateral.AverageTradingVolumeMethodologyEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class AverageTradingVolumeValidator implements Validator<AverageTradingVolume> {

	@Override
	public ValidationResult<AverageTradingVolume> validate(RosettaPath path, AverageTradingVolume o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("period", (Period) o.getPeriod() != null ? 1 : 0, 1, 1), 
				checkCardinality("methodology", (AverageTradingVolumeMethodologyEnum) o.getMethodology() != null ? 1 : 0, 1, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("AverageTradingVolume", ValidationType.CARDINALITY, "AverageTradingVolume", path, "", error);
		}
		return success("AverageTradingVolume", ValidationType.CARDINALITY, "AverageTradingVolume", path, "");
	}

}
