package cdm.product.asset.validation;

import cdm.observable.asset.Money;
import cdm.product.asset.StubFloatingRate;
import cdm.product.asset.StubValue;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class StubValueValidator implements Validator<StubValue> {

	@Override
	public ValidationResult<StubValue> validate(RosettaPath path, StubValue o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("floatingRate", (List<? extends StubFloatingRate>) o.getFloatingRate() == null ? 0 : ((List<? extends StubFloatingRate>) o.getFloatingRate()).size(), 0, 2), 
				checkCardinality("stubRate", (BigDecimal) o.getStubRate() != null ? 1 : 0, 0, 1), 
				checkCardinality("stubAmount", (Money) o.getStubAmount() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("StubValue", ValidationType.CARDINALITY, "StubValue", path, "", error);
		}
		return success("StubValue", ValidationType.CARDINALITY, "StubValue", path, "");
	}

}
