package cdm.product.asset.validation;

import cdm.observable.common.DeterminationMethodEnum;
import cdm.product.asset.DividendCurrency;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.ReferenceWithMetaString;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class DividendCurrencyValidator implements Validator<DividendCurrency> {

	@Override
	public ValidationResult<DividendCurrency> validate(RosettaPath path, DividendCurrency o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("currency", (FieldWithMetaString) o.getCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("determinationMethod", (DeterminationMethodEnum) o.getDeterminationMethod() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyReference", (ReferenceWithMetaString) o.getCurrencyReference() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("DividendCurrency", ValidationType.CARDINALITY, "DividendCurrency", path, "", error);
		}
		return success("DividendCurrency", ValidationType.CARDINALITY, "DividendCurrency", path, "");
	}

}
