package cdm.product.asset.validation;

import cdm.product.asset.BoundedCorrelation;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class BoundedCorrelationValidator implements Validator<BoundedCorrelation> {

	@Override
	public ValidationResult<BoundedCorrelation> validate(RosettaPath path, BoundedCorrelation o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("minimumBoundaryPercent", (BigDecimal) o.getMinimumBoundaryPercent() != null ? 1 : 0, 0, 1), 
				checkCardinality("maximumBoundaryPercent", (BigDecimal) o.getMaximumBoundaryPercent() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("BoundedCorrelation", ValidationType.CARDINALITY, "BoundedCorrelation", path, "", error);
		}
		return success("BoundedCorrelation", ValidationType.CARDINALITY, "BoundedCorrelation", path, "");
	}

}
