package cdm.product.asset.validation;

import cdm.base.datetime.DayOfWeekEnum;
import cdm.base.math.Quantity;
import cdm.observable.asset.Price;
import cdm.product.asset.AssetDeliveryProfileBlock;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.time.LocalTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class AssetDeliveryProfileBlockValidator implements Validator<AssetDeliveryProfileBlock> {

	@Override
	public ValidationResult<AssetDeliveryProfileBlock> validate(RosettaPath path, AssetDeliveryProfileBlock o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("startTime", (LocalTime) o.getStartTime() != null ? 1 : 0, 0, 1), 
				checkCardinality("endTime", (LocalTime) o.getEndTime() != null ? 1 : 0, 0, 1), 
				checkCardinality("dayOfWeek", (List<DayOfWeekEnum>) o.getDayOfWeek() == null ? 0 : ((List<DayOfWeekEnum>) o.getDayOfWeek()).size(), 0, 7), 
				checkCardinality("deliveryCapacity", (Quantity) o.getDeliveryCapacity() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceTimeIntervalQuantity", (Price) o.getPriceTimeIntervalQuantity() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("AssetDeliveryProfileBlock", ValidationType.CARDINALITY, "AssetDeliveryProfileBlock", path, "", error);
		}
		return success("AssetDeliveryProfileBlock", ValidationType.CARDINALITY, "AssetDeliveryProfileBlock", path, "");
	}

}
