package cdm.product.asset.validation;

import cdm.product.asset.AssetDeliveryProfileBlock;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class AssetDeliveryProfileBlockTypeFormatValidator implements Validator<AssetDeliveryProfileBlock> {

	@Override
	public ValidationResult<AssetDeliveryProfileBlock> validate(RosettaPath path, AssetDeliveryProfileBlock o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("AssetDeliveryProfileBlock", ValidationType.TYPE_FORMAT, "AssetDeliveryProfileBlock", path, "", error);
		}
		return success("AssetDeliveryProfileBlock", ValidationType.TYPE_FORMAT, "AssetDeliveryProfileBlock", path, "");
	}

}
