package cdm.product.asset.validation;

import cdm.base.math.Quantity;
import cdm.product.asset.AssetDeliveryInformation;
import cdm.product.asset.AssetDeliveryPeriods;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class AssetDeliveryInformationValidator implements Validator<AssetDeliveryInformation> {

	@Override
	public ValidationResult<AssetDeliveryInformation> validate(RosettaPath path, AssetDeliveryInformation o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("periods", (AssetDeliveryPeriods) o.getPeriods() != null ? 1 : 0, 0, 1), 
				checkCardinality("deliveryCapacity", (Quantity) o.getDeliveryCapacity() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("AssetDeliveryInformation", ValidationType.CARDINALITY, "AssetDeliveryInformation", path, "", error);
		}
		return success("AssetDeliveryInformation", ValidationType.CARDINALITY, "AssetDeliveryInformation", path, "");
	}

}
