package cdm.product.asset.validation;

import cdm.product.asset.AdditionalFixedPayments;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class AdditionalFixedPaymentsValidator implements Validator<AdditionalFixedPayments> {

	@Override
	public ValidationResult<AdditionalFixedPayments> validate(RosettaPath path, AdditionalFixedPayments o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("interestShortfallReimbursement", (Boolean) o.getInterestShortfallReimbursement() != null ? 1 : 0, 0, 1), 
				checkCardinality("principalShortfallReimbursement", (Boolean) o.getPrincipalShortfallReimbursement() != null ? 1 : 0, 0, 1), 
				checkCardinality("writedownReimbursement", (Boolean) o.getWritedownReimbursement() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("AdditionalFixedPayments", ValidationType.CARDINALITY, "AdditionalFixedPayments", path, "", error);
		}
		return success("AdditionalFixedPayments", ValidationType.CARDINALITY, "AdditionalFixedPayments", path, "");
	}

}
