package cdm.observable.asset.validation;

import cdm.observable.asset.ReferenceSwapCurve;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class ReferenceSwapCurveTypeFormatValidator implements Validator<ReferenceSwapCurve> {

	@Override
	public ValidationResult<ReferenceSwapCurve> validate(RosettaPath path, ReferenceSwapCurve o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("ReferenceSwapCurve", ValidationType.TYPE_FORMAT, "ReferenceSwapCurve", path, "", error);
		}
		return success("ReferenceSwapCurve", ValidationType.TYPE_FORMAT, "ReferenceSwapCurve", path, "");
	}

}
