package cdm.observable.asset.validation;

import cdm.base.staticdata.asset.common.metafields.FieldWithMetaCommodity;
import cdm.observable.asset.Observable;
import cdm.observable.asset.OptionReferenceTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaFloatingRateOption;
import cdm.observable.asset.metafields.FieldWithMetaQuotedCurrencyPair;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class ObservableValidator implements Validator<Observable> {

	@Override
	public ValidationResult<Observable> validate(RosettaPath path, Observable o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("rateOption", (FieldWithMetaFloatingRateOption) o.getRateOption() != null ? 1 : 0, 0, 1), 
				checkCardinality("commodity", (FieldWithMetaCommodity) o.getCommodity() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyPair", (FieldWithMetaQuotedCurrencyPair) o.getCurrencyPair() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionReferenceType", (OptionReferenceTypeEnum) o.getOptionReferenceType() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("Observable", ValidationType.CARDINALITY, "Observable", path, "", error);
		}
		return success("Observable", ValidationType.CARDINALITY, "Observable", path, "");
	}

}
