package cdm.observable.asset.calculatedrate.validation;

import cdm.observable.asset.calculatedrate.FallbackRateParameters;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class FallbackRateParametersTypeFormatValidator implements Validator<FallbackRateParameters> {

	@Override
	public ValidationResult<FallbackRateParameters> validate(RosettaPath path, FallbackRateParameters o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("FallbackRateParameters", ValidationType.TYPE_FORMAT, "FallbackRateParameters", path, "", error);
		}
		return success("FallbackRateParameters", ValidationType.TYPE_FORMAT, "FallbackRateParameters", path, "");
	}

}
