package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.functions.AddBusinessDays;
import cdm.base.datetime.functions.GenerateDateList;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GenerateObservationDates.GenerateObservationDatesDefault.class)
public abstract class GenerateObservationDates implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected AddBusinessDays addBusinessDays;
	@Inject protected GenerateDateList generateDateList;

	/**
	* @param observationPeriod The given observation period.
	* @param businessCenters The observation date.
	* @param lockoutDays The number of lockout date.
	* @return observationDates The resulting list of observation date.
	*/
	public List<Date> evaluate(CalculationPeriodBase observationPeriod, List<BusinessCenterEnum> businessCenters, Integer lockoutDays) {
		List<Date> observationDates = doEvaluate(observationPeriod, businessCenters, lockoutDays);
		
		return observationDates;
	}

	protected abstract List<Date> doEvaluate(CalculationPeriodBase observationPeriod, List<BusinessCenterEnum> businessCenters, Integer lockoutDays);

	protected abstract Mapper<Integer> days(CalculationPeriodBase observationPeriod, List<BusinessCenterEnum> businessCenters, Integer lockoutDays);

	protected abstract Mapper<Date> endDate(CalculationPeriodBase observationPeriod, List<BusinessCenterEnum> businessCenters, Integer lockoutDays);

	public static class GenerateObservationDatesDefault extends GenerateObservationDates {
		@Override
		protected List<Date> doEvaluate(CalculationPeriodBase observationPeriod, List<BusinessCenterEnum> businessCenters, Integer lockoutDays) {
			List<Date> observationDates = new ArrayList<>();
			return assignOutput(observationDates, observationPeriod, businessCenters, lockoutDays);
		}
		
		protected List<Date> assignOutput(List<Date> observationDates, CalculationPeriodBase observationPeriod, List<BusinessCenterEnum> businessCenters, Integer lockoutDays) {
			List<Date> addVar = MapperC.<Date>of(generateDateList.evaluate(MapperS.of(observationPeriod).<Date>map("getAdjustedStartDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedStartDate()).get(), MapperS.of(endDate(observationPeriod, businessCenters, lockoutDays).get()).get(), MapperC.<BusinessCenterEnum>of(businessCenters).getMulti())).getMulti();
			observationDates.addAll(addVar);
			
			return observationDates;
		}
		
		@Override
		protected Mapper<Integer> days(CalculationPeriodBase observationPeriod, List<BusinessCenterEnum> businessCenters, Integer lockoutDays) {
			return MapperMaths.<Integer, Integer, Integer>add(MapperS.of(Integer.valueOf(1)), MapperUtils.runSingle(() -> {
				if (exists(MapperS.of(lockoutDays)).getOrDefault(false)) {
					return MapperS.of(lockoutDays);
				}
				else {
					return MapperS.of(Integer.valueOf(0));
				}
			}));
		}
		
		@Override
		protected Mapper<Date> endDate(CalculationPeriodBase observationPeriod, List<BusinessCenterEnum> businessCenters, Integer lockoutDays) {
			return MapperS.of(addBusinessDays.evaluate(MapperS.of(observationPeriod).<Date>map("getAdjustedEndDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedEndDate()).get(), MapperMaths.<Integer, Integer, Integer>multiply(MapperS.of(Integer.valueOf(-1)), MapperS.of(days(observationPeriod, businessCenters, lockoutDays).get())).get(), MapperC.<BusinessCenterEnum>of(businessCenters).getMulti()));
		}
	}
}
