package cdm.legaldocumentation.common.validation;

import cdm.base.staticdata.party.Counterparty;
import cdm.legaldocumentation.common.AgreementTerms;
import cdm.legaldocumentation.contract.Agreement;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class AgreementTermsValidator implements Validator<AgreementTerms> {

	@Override
	public ValidationResult<AgreementTerms> validate(RosettaPath path, AgreementTerms o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("agreement", (Agreement) o.getAgreement() != null ? 1 : 0, 1, 1), 
				checkCardinality("clauseLibrary", (Boolean) o.getClauseLibrary() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty", (List<? extends Counterparty>) o.getCounterparty() == null ? 0 : ((List<? extends Counterparty>) o.getCounterparty()).size(), 2, 2)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("AgreementTerms", ValidationType.CARDINALITY, "AgreementTerms", path, "", error);
		}
		return success("AgreementTerms", ValidationType.CARDINALITY, "AgreementTerms", path, "");
	}

}
