package cdm.legaldocumentation.common.validation;

import cdm.legaldocumentation.common.AgreementTerms;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class AgreementTermsTypeFormatValidator implements Validator<AgreementTerms> {

	@Override
	public ValidationResult<AgreementTerms> validate(RosettaPath path, AgreementTerms o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("AgreementTerms", ValidationType.TYPE_FORMAT, "AgreementTerms", path, "", error);
		}
		return success("AgreementTerms", ValidationType.TYPE_FORMAT, "AgreementTerms", path, "");
	}

}
