package cdm.event.workflow.validation;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.workflow.CustomisedWorkflow;
import cdm.event.workflow.PartyCustomisedWorkflow;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class PartyCustomisedWorkflowValidator implements Validator<PartyCustomisedWorkflow> {

	@Override
	public ValidationResult<PartyCustomisedWorkflow> validate(RosettaPath path, PartyCustomisedWorkflow o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("partyReference", (ReferenceWithMetaParty) o.getPartyReference() != null ? 1 : 0, 0, 1), 
				checkCardinality("partyName", (String) o.getPartyName() != null ? 1 : 0, 0, 1), 
				checkCardinality("customisedWorkflow", (List<? extends CustomisedWorkflow>) o.getCustomisedWorkflow() == null ? 0 : ((List<? extends CustomisedWorkflow>) o.getCustomisedWorkflow()).size(), 1, 0)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("PartyCustomisedWorkflow", ValidationType.CARDINALITY, "PartyCustomisedWorkflow", path, "", error);
		}
		return success("PartyCustomisedWorkflow", ValidationType.CARDINALITY, "PartyCustomisedWorkflow", path, "");
	}

}
