package cdm.event.position.validation;

import cdm.event.common.metafields.ReferenceWithMetaContractDetails;
import cdm.event.common.metafields.ReferenceWithMetaExecutionDetails;
import cdm.event.position.CounterpartyPosition;
import cdm.product.collateral.metafields.ReferenceWithMetaCollateral;
import cdm.product.template.TradableProduct;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.time.LocalDateTime;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CounterpartyPositionValidator implements Validator<CounterpartyPosition> {

	@Override
	public ValidationResult<CounterpartyPosition> validate(RosettaPath path, CounterpartyPosition o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("contractDetails", (ReferenceWithMetaContractDetails) o.getContractDetails() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionDetails", (ReferenceWithMetaExecutionDetails) o.getExecutionDetails() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateral", (ReferenceWithMetaCollateral) o.getCollateral() != null ? 1 : 0, 0, 1), 
				checkCardinality("openDateTime", (LocalDateTime) o.getOpenDateTime() != null ? 1 : 0, 0, 1), 
				checkCardinality("positionBase", (TradableProduct) o.getPositionBase() != null ? 1 : 0, 1, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CounterpartyPosition", ValidationType.CARDINALITY, "CounterpartyPosition", path, "", error);
		}
		return success("CounterpartyPosition", ValidationType.CARDINALITY, "CounterpartyPosition", path, "");
	}

}
