package cdm.event.common.validation;

import cdm.event.common.ObservationEvent;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class ObservationEventTypeFormatValidator implements Validator<ObservationEvent> {

	@Override
	public ValidationResult<ObservationEvent> validate(RosettaPath path, ObservationEvent o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("ObservationEvent", ValidationType.TYPE_FORMAT, "ObservationEvent", path, "", error);
		}
		return success("ObservationEvent", ValidationType.TYPE_FORMAT, "ObservationEvent", path, "");
	}

}
