package cdm.event.common.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.BusinessEvent;
import cdm.event.common.Instruction;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.observable.asset.Observable;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.collateral.Collateral;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Qualify_OnDemandRateChange.Qualify_OnDemandRateChangeDefault.class)
public abstract class Qualify_OnDemandRateChange implements RosettaFunction,IQualifyFunctionExtension<BusinessEvent> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FilterClosedTradeStates filterClosedTradeStates;
	@Inject protected FilterOpenTradeStates filterOpenTradeStates;

	/**
	* @param businessEvent 
	* @return is_event 
	*/
	@Override
	public Boolean evaluate(BusinessEvent businessEvent) {
		Boolean is_event = doEvaluate(businessEvent);
		
		return is_event;
	}

	protected abstract Boolean doEvaluate(BusinessEvent businessEvent);

	protected abstract Mapper<? extends TradableProduct> beforeTradableProduct(BusinessEvent businessEvent);

	protected abstract Mapper<? extends EconomicTerms> beforeEconomicterms(BusinessEvent businessEvent);

	protected abstract Mapper<? extends TradableProduct> openTradableProduct(BusinessEvent businessEvent);

	protected abstract Mapper<? extends EconomicTerms> openEconomicTerms(BusinessEvent businessEvent);

	protected abstract Mapper<? extends TradeState> closedTradeState(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> beforePriceQuantityRateOnly(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> openPriceQuantityRateOnly(BusinessEvent businessEvent);

	protected abstract Mapper<? extends PriceQuantity> beforePriceQuantityNoRate(BusinessEvent businessEvent);

	protected abstract Mapper<? extends PriceQuantity> openPriceQuantityNoRate(BusinessEvent businessEvent);

	public static class Qualify_OnDemandRateChangeDefault extends Qualify_OnDemandRateChange {
		@Override
		protected Boolean doEvaluate(BusinessEvent businessEvent) {
			Boolean is_event = null;
			return assignOutput(is_event, businessEvent);
		}
		
		protected Boolean assignOutput(Boolean is_event, BusinessEvent businessEvent) {
			is_event = exists(MapperS.of(beforeEconomicterms(businessEvent).get())).and(exists(MapperS.of(openEconomicTerms(businessEvent).get()))).and(areEqual(MapperS.of(MapperC.<TradeState>of(closedTradeState(businessEvent).getMulti()).resultCount()), MapperS.of(Integer.valueOf(1)), CardinalityOperator.All)).and(areEqual(MapperS.of(openEconomicTerms(businessEvent).get()).<Collateral>map("getCollateral", economicTerms -> economicTerms.getCollateral()), MapperS.of(beforeEconomicterms(businessEvent).get()).<Collateral>map("getCollateral", economicTerms -> economicTerms.getCollateral()), CardinalityOperator.All)).and(areEqual(MapperS.of(MapperC.<BigDecimal>of(beforePriceQuantityRateOnly(businessEvent).getMulti()).resultCount()), MapperS.of(Integer.valueOf(1)), CardinalityOperator.All)).and(areEqual(MapperS.of(MapperC.<BigDecimal>of(openPriceQuantityRateOnly(businessEvent).getMulti()).resultCount()), MapperS.of(Integer.valueOf(1)), CardinalityOperator.All)).and(notEqual(MapperS.of(MapperC.<BigDecimal>of(beforePriceQuantityRateOnly(businessEvent).getMulti()).get()), MapperS.of(MapperC.<BigDecimal>of(openPriceQuantityRateOnly(businessEvent).getMulti()).get()), CardinalityOperator.Any)).and(areEqual(MapperC.<PriceQuantity>of(beforePriceQuantityNoRate(businessEvent).getMulti()), MapperC.<PriceQuantity>of(openPriceQuantityNoRate(businessEvent).getMulti()), CardinalityOperator.All)).get();
			
			return is_event;
		}
		
		@Override
		protected Mapper<? extends TradableProduct> beforeTradableProduct(BusinessEvent businessEvent) {
			return MapperS.of(MapperS.of(businessEvent).<Instruction>mapC("getInstruction", eventInstruction -> eventInstruction.getInstruction()).get()).<ReferenceWithMetaTradeState>map("getBefore", instruction -> instruction.getBefore()).<TradeState>map("getValue", _f->_f.getValue()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct());
		}
		
		@Override
		protected Mapper<? extends EconomicTerms> beforeEconomicterms(BusinessEvent businessEvent) {
			return MapperS.of(beforeTradableProduct(businessEvent).get()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms());
		}
		
		@Override
		protected Mapper<? extends TradableProduct> openTradableProduct(BusinessEvent businessEvent) {
			return MapperS.of(MapperC.<TradeState>of(filterOpenTradeStates.evaluate(MapperS.of(businessEvent).<TradeState>mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti())).get()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct());
		}
		
		@Override
		protected Mapper<? extends EconomicTerms> openEconomicTerms(BusinessEvent businessEvent) {
			return MapperS.of(openTradableProduct(businessEvent).get()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms());
		}
		
		@Override
		protected Mapper<? extends TradeState> closedTradeState(BusinessEvent businessEvent) {
			return MapperC.<TradeState>of(filterClosedTradeStates.evaluate(MapperS.of(businessEvent).<TradeState>mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti()));
		}
		
		@Override
		protected Mapper<BigDecimal> beforePriceQuantityRateOnly(BusinessEvent businessEvent) {
			return MapperS.of(MapperS.of(beforeTradableProduct(businessEvent).get()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity())
				.mapItemToList(item -> (MapperC<PriceSchedule>)item.<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).<PriceSchedule>map("getValue", _f->_f.getValue()))
				.apply(item -> item
					.flattenList())
				.apply(item -> item
					.filterItemNullSafe(_item -> (Boolean)areEqual(_item.<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.INTEREST_RATE), CardinalityOperator.All).get()))
				.apply(item -> item
					.mapItem(_item -> (MapperS<BigDecimal>)_item.<BigDecimal>map("getValue", measureBase -> measureBase.getValue())));
		}
		
		@Override
		protected Mapper<BigDecimal> openPriceQuantityRateOnly(BusinessEvent businessEvent) {
			return MapperS.of(MapperS.of(openTradableProduct(businessEvent).get()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity())
				.mapItemToList(item -> (MapperC<PriceSchedule>)item.<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).<PriceSchedule>map("getValue", _f->_f.getValue()))
				.apply(item -> item
					.flattenList())
				.apply(item -> item
					.filterItemNullSafe(_item -> (Boolean)areEqual(_item.<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.INTEREST_RATE), CardinalityOperator.All).get()))
				.apply(item -> item
					.mapItem(_item -> (MapperS<BigDecimal>)_item.<BigDecimal>map("getValue", measureBase -> measureBase.getValue())));
		}
		
		@Override
		protected Mapper<? extends PriceQuantity> beforePriceQuantityNoRate(BusinessEvent businessEvent) {
			return MapperS.of(MapperS.of(beforeTradableProduct(businessEvent).get()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity())
				.mapItem(item -> (MapperS<PriceQuantity>)MapperS.of(PriceQuantity.builder()
					.setPriceValue(item.<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).<PriceSchedule>map("getValue", _f->_f.getValue())
						.filterItemNullSafe(p -> (Boolean)notEqual(p.<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.INTEREST_RATE), CardinalityOperator.Any).get()).getMulti())
					.setQuantityValue(item.<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).<NonNegativeQuantitySchedule>map("getValue", _f->_f.getValue()).getMulti())
					.setObservable(item.<Observable>map("getObservable", priceQuantity -> priceQuantity.getObservable()).get())
					.build())
				);
		}
		
		@Override
		protected Mapper<? extends PriceQuantity> openPriceQuantityNoRate(BusinessEvent businessEvent) {
			return MapperS.of(MapperS.of(openTradableProduct(businessEvent).get()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity())
				.mapItem(item -> (MapperS<PriceQuantity>)MapperS.of(PriceQuantity.builder()
					.setPriceValue(item.<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).<PriceSchedule>map("getValue", _f->_f.getValue())
						.filterItemNullSafe(p -> (Boolean)notEqual(p.<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.INTEREST_RATE), CardinalityOperator.Any).get()).getMulti())
					.setQuantityValue(item.<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).<NonNegativeQuantitySchedule>map("getValue", _f->_f.getValue()).getMulti())
					.setObservable(item.<Observable>map("getObservable", priceQuantity -> priceQuantity.getObservable()).get())
					.build())
				);
		}
	}
		
		@Override
		public String getNamePrefix() {
			return "Qualify";
		}
}
