package cdm.event.common.functions;

import cdm.event.common.Reset;
import cdm.event.common.ResetInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.TradeState.TradeStateBuilder;
import cdm.observable.event.Observation;
import cdm.observable.event.ObservationIdentifier;
import cdm.observable.event.functions.ResolveObservation;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.metafields.ReferenceWithMetaPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Create_Reset.Create_ResetDefault.class)
public abstract class Create_Reset implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ResolveInterestRateObservationIdentifiers resolveInterestRateObservationIdentifiers;
	@Inject protected ResolveInterestRateReset resolveInterestRateReset;
	@Inject protected ResolveObservation resolveObservation;
	@Inject protected ResolvePerformanceObservationIdentifiers resolvePerformanceObservationIdentifiers;
	@Inject protected ResolvePerformanceReset resolvePerformanceReset;

	/**
	* @param instruction Specifies the reset instructions.
	* @param tradeState Specifies the trade that is resetting.
	* @return reset 
	*/
	public TradeState evaluate(ResetInstruction instruction, TradeState tradeState) {
		TradeState.TradeStateBuilder resetBuilder = doEvaluate(instruction, tradeState);
		
		final TradeState reset;
		if (resetBuilder == null) {
			reset = null;
		} else {
			reset = resetBuilder.build();
			objectValidator.validate(TradeState.class, reset);
		}
		
		return reset;
	}

	protected abstract TradeState.TradeStateBuilder doEvaluate(ResetInstruction instruction, TradeState tradeState);

	protected abstract Mapper<? extends Payout> payout(ResetInstruction instruction, TradeState tradeState);

	protected abstract Mapper<Date> observationDate(ResetInstruction instruction, TradeState tradeState);

	protected abstract Mapper<? extends ObservationIdentifier> observationIdentifiers(ResetInstruction instruction, TradeState tradeState);

	protected abstract Mapper<? extends Observation> observation(ResetInstruction instruction, TradeState tradeState);

	public static class Create_ResetDefault extends Create_Reset {
		@Override
		protected TradeState.TradeStateBuilder doEvaluate(ResetInstruction instruction, TradeState tradeState) {
			TradeState.TradeStateBuilder reset = TradeState.builder();
			return assignOutput(reset, instruction, tradeState);
		}
		
		protected TradeState.TradeStateBuilder assignOutput(TradeState.TradeStateBuilder reset, ResetInstruction instruction, TradeState tradeState) {
			reset = toBuilder(MapperS.of(tradeState).get());
			
			reset
				.addResetHistory(MapperUtils.runSinglePolymorphic(() -> {
					if (areEqual(MapperS.of(MapperS.of(payout(instruction, tradeState).get()).<PerformancePayout>mapC("getPerformancePayout", _payout -> _payout.getPerformancePayout()).resultCount()), MapperS.of(Integer.valueOf(1)), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(resolvePerformanceReset.evaluate(MapperS.of(MapperS.of(payout(instruction, tradeState).get()).<PerformancePayout>mapC("getPerformancePayout", _payout -> _payout.getPerformancePayout()).get()).get(), MapperS.of(observation(instruction, tradeState).get()).get(), MapperS.of(instruction).<Date>map("getResetDate", resetInstruction -> resetInstruction.getResetDate()).get()));
					}
					else if (exists(MapperS.of(payout(instruction, tradeState).get()).<InterestRatePayout>mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout())).getOrDefault(false)) {
						return MapperS.of(resolveInterestRateReset.evaluate(MapperS.of(payout(instruction, tradeState).get()).<InterestRatePayout>mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).getMulti(), MapperS.of(observation(instruction, tradeState).get()).get(), MapperS.of(instruction).<Date>map("getResetDate", resetInstruction -> resetInstruction.getResetDate()).get(), MapperS.of(instruction).<Date>map("getRateRecordDate", resetInstruction -> resetInstruction.getRateRecordDate()).get()));
					}
					else {
						return MapperS.<Reset>ofNull();
					}
				}).getMulti());
			
			return Optional.ofNullable(reset)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected Mapper<? extends Payout> payout(ResetInstruction instruction, TradeState tradeState) {
			return MapperS.of(instruction).<ReferenceWithMetaPayout>map("getPayout", resetInstruction -> resetInstruction.getPayout()).<Payout>map("getValue", _f->_f.getValue());
		}
		
		@Override
		protected Mapper<Date> observationDate(ResetInstruction instruction, TradeState tradeState) {
			return MapperUtils.runSingle(() -> {
				if (exists(MapperS.of(instruction).<Date>map("getRateRecordDate", resetInstruction -> resetInstruction.getRateRecordDate())).getOrDefault(false)) {
					return MapperS.of(instruction).<Date>map("getRateRecordDate", resetInstruction -> resetInstruction.getRateRecordDate());
				}
				else {
					return MapperS.of(instruction).<Date>map("getResetDate", resetInstruction -> resetInstruction.getResetDate());
				}
			});
		}
		
		@Override
		protected Mapper<? extends ObservationIdentifier> observationIdentifiers(ResetInstruction instruction, TradeState tradeState) {
			return MapperUtils.runSinglePolymorphic(() -> {
				if (areEqual(MapperS.of(MapperS.of(payout(instruction, tradeState).get()).<PerformancePayout>mapC("getPerformancePayout", _payout -> _payout.getPerformancePayout()).resultCount()), MapperS.of(Integer.valueOf(1)), CardinalityOperator.All).getOrDefault(false)) {
					return MapperS.of(resolvePerformanceObservationIdentifiers.evaluate(MapperS.of(MapperS.of(payout(instruction, tradeState).get()).<PerformancePayout>mapC("getPerformancePayout", _payout -> _payout.getPerformancePayout()).get()).get(), MapperS.of(instruction).<Date>map("getResetDate", resetInstruction -> resetInstruction.getResetDate()).get()));
				}
				else if (exists(MapperS.of(payout(instruction, tradeState).get()).<InterestRatePayout>mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout())).getOrDefault(false)) {
					return MapperS.of(resolveInterestRateObservationIdentifiers.evaluate(MapperS.of(MapperS.of(payout(instruction, tradeState).get()).<InterestRatePayout>mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).get()).get(), MapperS.of(observationDate(instruction, tradeState).get()).get()));
				}
				else {
					return MapperS.<ObservationIdentifier>ofNull();
				}
			});
		}
		
		@Override
		protected Mapper<? extends Observation> observation(ResetInstruction instruction, TradeState tradeState) {
			return MapperS.of(resolveObservation.evaluate(MapperC.<ObservationIdentifier>of(MapperS.of(observationIdentifiers(instruction, tradeState).get())).getMulti(), null));
		}
	}
}
