package cdm.base.staticdata.party.validation;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.BusinessUnit;
import cdm.base.staticdata.party.ContactInformation;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class BusinessUnitValidator implements Validator<BusinessUnit> {

	@Override
	public ValidationResult<BusinessUnit> validate(RosettaPath path, BusinessUnit o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("name", (String) o.getName() != null ? 1 : 0, 1, 1), 
				checkCardinality("identifier", (Identifier) o.getIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("contactInformation", (ContactInformation) o.getContactInformation() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("BusinessUnit", ValidationType.CARDINALITY, "BusinessUnit", path, "", error);
		}
		return success("BusinessUnit", ValidationType.CARDINALITY, "BusinessUnit", path, "");
	}

}
