package cdm.base.staticdata.asset.common.validation;

import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.base.staticdata.asset.common.TaxonomyValue;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaAssetClassEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class ProductTaxonomyValidator implements Validator<ProductTaxonomy> {

	@Override
	public ValidationResult<ProductTaxonomy> validate(RosettaPath path, ProductTaxonomy o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("source", (TaxonomySourceEnum) o.getSource() != null ? 1 : 0, 0, 1), 
				checkCardinality("value", (TaxonomyValue) o.getValue() != null ? 1 : 0, 0, 1), 
				checkCardinality("primaryAssetClass", (FieldWithMetaAssetClassEnum) o.getPrimaryAssetClass() != null ? 1 : 0, 0, 1), 
				checkCardinality("productQualifier", (String) o.getProductQualifier() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("ProductTaxonomy", ValidationType.CARDINALITY, "ProductTaxonomy", path, "", error);
		}
		return success("ProductTaxonomy", ValidationType.CARDINALITY, "ProductTaxonomy", path, "");
	}

}
