package cdm.base.datetime.validation.datarule;

import cdm.base.datetime.DayTypeEnum;
import cdm.base.datetime.Offset;
import cdm.base.datetime.PeriodEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.0.0
 */
@RosettaDataRule("OffsetDayType")
@ImplementedBy(OffsetDayType.Default.class)
public interface OffsetDayType extends Validator<Offset> {
	
	String NAME = "OffsetDayType";
	String DEFINITION = "if period <> PeriodEnum -> D or periodMultiplier = 0 then dayType is absent";
	
	ValidationResult<Offset> validate(RosettaPath path, Offset offset);
	
	class Default implements OffsetDayType {
	
		@Override
		public ValidationResult<Offset> validate(RosettaPath path, Offset offset) {
			ComparisonResult result = executeDataRule(offset);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "Offset", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null) {
				failureMessage = "Condition " + NAME + " failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "Offset", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(Offset offset) {
			try {
				ComparisonResult result = MapperUtils.toComparisonResult(MapperUtils.runSingle(() -> {
					if (notEqual(MapperS.of(offset).<PeriodEnum>map("getPeriod", period -> period.getPeriod()), MapperS.of(PeriodEnum.D), CardinalityOperator.Any).or(areEqual(MapperS.of(offset).<Integer>map("getPeriodMultiplier", period -> period.getPeriodMultiplier()), MapperS.of(Integer.valueOf(0)), CardinalityOperator.All)).getOrDefault(false)) {
						return notExists(MapperS.of(offset).<DayTypeEnum>map("getDayType", _offset -> _offset.getDayType()));
					}
					else {
						return null;
					}
				}));
				return result.get() == null ? ComparisonResult.success() : result;
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements OffsetDayType {
	
		@Override
		public ValidationResult<Offset> validate(RosettaPath path, Offset offset) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "Offset", path, DEFINITION);
		}
	}
}
