package cdm.base.datetime.validation;

import cdm.base.datetime.TimeZone;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.time.LocalTime;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class TimeZoneValidator implements Validator<TimeZone> {

	@Override
	public ValidationResult<TimeZone> validate(RosettaPath path, TimeZone o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("time", (LocalTime) o.getTime() != null ? 1 : 0, 1, 1), 
				checkCardinality("location", (FieldWithMetaString) o.getLocation() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("TimeZone", ValidationType.CARDINALITY, "TimeZone", path, "", error);
		}
		return success("TimeZone", ValidationType.CARDINALITY, "TimeZone", path, "");
	}

}
