package cdm.base.datetime.validation;

import cdm.base.datetime.BusinessCenterTime;
import cdm.base.datetime.CalculationFrequency;
import cdm.base.datetime.DayOfWeekEnum;
import cdm.base.datetime.Period;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CalculationFrequencyValidator implements Validator<CalculationFrequency> {

	@Override
	public ValidationResult<CalculationFrequency> validate(RosettaPath path, CalculationFrequency o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("period", (Period) o.getPeriod() != null ? 1 : 0, 1, 1), 
				checkCardinality("monthOfYear", (BigDecimal) o.getMonthOfYear() != null ? 1 : 0, 0, 1), 
				checkCardinality("dayOfMonth", (BigDecimal) o.getDayOfMonth() != null ? 1 : 0, 0, 1), 
				checkCardinality("dayOfWeek", (DayOfWeekEnum) o.getDayOfWeek() != null ? 1 : 0, 0, 1), 
				checkCardinality("weekOfMonth", (BigDecimal) o.getWeekOfMonth() != null ? 1 : 0, 0, 1), 
				checkCardinality("offsetDays", (BigDecimal) o.getOffsetDays() != null ? 1 : 0, 1, 1), 
				checkCardinality("dateLocation", (BusinessCenterTime) o.getDateLocation() != null ? 1 : 0, 1, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CalculationFrequency", ValidationType.CARDINALITY, "CalculationFrequency", path, "", error);
		}
		return success("CalculationFrequency", ValidationType.CARDINALITY, "CalculationFrequency", path, "");
	}

}
