package cdm.base.datetime.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.records.Date;
import java.time.ZonedDateTime;


@ImplementedBy(ToDateTime.ToDateTimeDefault.class)
public abstract class ToDateTime implements RosettaFunction {

	/**
	* @param date 
	* @return datetime 
	*/
	public ZonedDateTime evaluate(Date date) {
		ZonedDateTime datetime = doEvaluate(date);
		
		return datetime;
	}

	protected abstract ZonedDateTime doEvaluate(Date date);

	public static class ToDateTimeDefault extends ToDateTime {
		@Override
		protected ZonedDateTime doEvaluate(Date date) {
			ZonedDateTime datetime = null;
			return assignOutput(datetime, date);
		}
		
		protected ZonedDateTime assignOutput(ZonedDateTime datetime, Date date) {
			return datetime;
		}
	}
}
