/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashSet;
import java.util.Set;
import org.ff4j.property.Property;
import org.ff4j.property.util.PropertyFactory;

@ApiModel(value="propertyApiBean", description="ff4j property representation")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PropertyApiBean {
    @JsonProperty(value="name")
    @ApiModelProperty(value="unique property name", required=true)
    private String name;
    @JsonProperty(value="description")
    @ApiModelProperty(value="property description", required=false)
    private String description;
    @JsonProperty(value="type")
    @ApiModelProperty(value="classname of implementation", required=true)
    private String type;
    @JsonProperty(value="value")
    @ApiModelProperty(value="value", required=true)
    private String value;
    @JsonProperty(value="fixedValues")
    @ApiModelProperty(value="fixedValues", required=false)
    private Set<String> fixedValues = new HashSet<String>();

    public PropertyApiBean() {
    }

    public PropertyApiBean(Property<?> property) {
        if (property != null) {
            this.name = property.getName();
            this.description = property.getDescription();
            this.type = property.getType();
            this.value = property.asString();
            if (property.getFixedValues() != null) {
                for (Object fv : property.getFixedValues()) {
                    this.fixedValues.add(fv.toString());
                }
            }
        }
    }

    public Property<?> asProperty() {
        return PropertyFactory.createProperty((String)this.name, (String)this.type, (String)this.value, (String)this.description, this.fixedValues);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Set<String> getFixedValues() {
        return this.fixedValues;
    }

    public void setFixedValues(Set<String> fixedValues) {
        this.fixedValues = fixedValues;
    }
}

