/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.audit.repository.EventRepository;
import org.ff4j.web.api.resources.domain.BarChartApiBean;
import org.ff4j.web.api.resources.domain.PieChartApiBean;
import org.ff4j.web.api.resources.domain.PieSectorApiBean;

@ApiModel(value="eventRepositoryApiBean", description="resource representation of monitoring resources")
public class EventRepositoryApiBean {
    @ApiModelProperty(value="type of the repository", required=true)
    @JsonProperty(value="type")
    private String type;
    @ApiModelProperty(value="total hit of the monitoring", required=true)
    @JsonProperty(value="hitCount")
    private int hitCount = 0;
    @ApiModelProperty(value="pie of features", required=true)
    @JsonProperty(value="eventsPie")
    private PieChartApiBean eventsPie;
    @ApiModelProperty(value="barChart for activity", required=true)
    @JsonProperty(value="barChart")
    private BarChartApiBean barChart;

    public EventRepositoryApiBean() {
    }

    public EventRepositoryApiBean(EventRepository evtRepository, Long start, Long end) {
        this.type = evtRepository.getClass().getName();
        EventQueryDefinition query = new EventQueryDefinition();
        if (start != null) {
            query.setFrom(start);
        }
        if (end != null) {
            query.setTo(end);
        }
        this.eventsPie = new PieChartApiBean(evtRepository.getFeatureUsagePieChart(query));
        this.barChart = new BarChartApiBean(evtRepository.getFeatureUsageBarChart(query));
        for (PieSectorApiBean sector : this.eventsPie.getSectors()) {
            this.hitCount = (int)((double)this.hitCount + sector.getValue());
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public void setHitCount(int hitCount) {
        this.hitCount = hitCount;
    }

    public PieChartApiBean getEventsPie() {
        return this.eventsPie;
    }

    public void setEventsPie(PieChartApiBean eventsPie) {
        this.eventsPie = eventsPie;
    }

    public BarChartApiBean getBarChart() {
        return this.barChart;
    }

    public void setBarChart(BarChartApiBean barChart) {
        this.barChart = barChart;
    }
}

