/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashSet;
import java.util.Set;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.core.FeatureStore;
import org.ff4j.property.store.PropertyStore;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(value="cacheApiBean", description="cache resource representation")
public class CacheApiBean {
    @JsonProperty(value="cacheProvider")
    @ApiModelProperty(value="if a cachestore is defined", required=false)
    private String cacheProvider = null;
    @JsonProperty(value="cacheStore")
    @ApiModelProperty(value="if a cachestore is defined", required=false)
    private String cacheStore = null;
    @JsonProperty(value="featureNames")
    @ApiModelProperty(value="list of features within cache", required=false)
    private Set<String> featureNames = new HashSet<String>();
    @JsonProperty(value="propertyNames")
    @ApiModelProperty(value="list of properties within cache", required=false)
    private Set<String> propertyNames = new HashSet<String>();

    public CacheApiBean(FeatureStore featureStore) {
        if (featureStore instanceof FF4jCacheProxy) {
            FF4jCacheProxy cacheProxy = (FF4jCacheProxy)featureStore;
            this.cacheStore = cacheProxy.getCachedTargetStore();
            this.cacheProvider = cacheProxy.getCacheProvider();
            this.featureNames = cacheProxy.getCacheManager().listCachedFeatureNames();
        }
    }

    public CacheApiBean(PropertyStore featureStore) {
        if (featureStore instanceof FF4jCacheProxy) {
            FF4jCacheProxy cacheProxy = (FF4jCacheProxy)featureStore;
            this.cacheStore = cacheProxy.getCachedTargetStore();
            this.cacheProvider = cacheProxy.getCacheProvider();
            this.propertyNames = cacheProxy.getCacheManager().listCachedPropertyNames();
        }
    }

    public String getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(String cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public String getCacheStore() {
        return this.cacheStore;
    }

    public void setCacheStore(String cacheStore) {
        this.cacheStore = cacheStore;
    }

    public Set<String> getFeatureNames() {
        return this.featureNames;
    }

    public void setFeatureNames(Set<String> featureNames) {
        this.featureNames = featureNames;
    }

    public Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(Set<String> propertyNames) {
        this.propertyNames = propertyNames;
    }
}

