/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.exception.PropertyAccessException;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.exception.PropertyNotFoundException;

@Provider
public class RuntimeExceptionMapper
implements ExceptionMapper<RuntimeException> {
    private static final String CONTENT_TYPE = "text/plain";

    public Response toResponse(RuntimeException rex) {
        Response.Status myStatus = this.getStatus(rex);
        return Response.status((Response.Status)myStatus).entity((Object)rex.getMessage()).type(CONTENT_TYPE).build();
    }

    public Response.Status getStatus(RuntimeException rex) {
        if (rex instanceof FeatureNotFoundException || rex instanceof GroupNotFoundException || rex instanceof PropertyNotFoundException) {
            return Response.Status.NOT_FOUND;
        }
        if (rex instanceof FeatureAlreadyExistException || rex instanceof PropertyAlreadyExistException) {
            return Response.Status.CONFLICT;
        }
        if (rex instanceof FeatureAccessException || rex instanceof PropertyAccessException) {
            return Response.Status.SERVICE_UNAVAILABLE;
        }
        if (rex instanceof WebApplicationException) {
            return Response.Status.fromStatusCode((int)((WebApplicationException)rex).getResponse().getStatus());
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }
}

