/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.web.api.resources.AbstractResource;
import org.ff4j.web.api.resources.domain.PropertyApiBean;

@Path(value="/ff4j/propertyStore/properties/{name}")
@Produces(value={"application/json"})
@RolesAllowed(value={"WRITE"})
@Api(value="/ff4j/propertyStore/properties/{name}")
public class PropertyResource
extends AbstractResource {
    @GET
    @RolesAllowed(value={"READ"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Read information about a Property", response=PropertyApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Information about features"), @ApiResponse(code=404, message="Property not found")})
    public Response read(@PathParam(value="name") String name) {
        if (!this.ff4j.getPropertiesStore().existProperty(name)) {
            String errMsg = new PropertyNotFoundException(name).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        return Response.ok((Object)new PropertyApiBean(this.ff4j.getPropertiesStore().readProperty(name))).build();
    }

    @PUT
    @RolesAllowed(value={"WRITE"})
    @ApiOperation(value="Create of update a Property", response=Response.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=201, message="Property has been created"), @ApiResponse(code=204, message="No content, feature is updated")})
    public Response upsertProperty(@Context HttpHeaders headers, @PathParam(value="name") String name, PropertyApiBean pApiBean) {
        if ("".equals(name) || !name.equals(pApiBean.getName())) {
            String errMsg = "Invalid identifier expected " + name;
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        Property<?> property = pApiBean.asProperty();
        if (!this.getPropertyStore().existProperty(property.getName())) {
            this.getPropertyStore().createProperty(property);
            String location = String.format("%s", this.uriInfo.getAbsolutePath().toString());
            try {
                return Response.created((URI)new URI(location)).build();
            }
            catch (URISyntaxException e) {
                return Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)location).entity((Object)name).build();
            }
        }
        this.getPropertyStore().updateProperty(property);
        return Response.noContent().build();
    }

    @DELETE
    @RolesAllowed(value={"WRITE"})
    @Produces(value={"text/plain"})
    @ApiOperation(value="Delete a Property", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Property has not been found"), @ApiResponse(code=204, message="No content, Property is deleted"), @ApiResponse(code=400, message="Bad identifier")})
    public Response deleteProperty(@PathParam(value="name") String name) {
        if (name == null || "".equals(name)) {
            String errMsg = "Invalid URL : Must be '/properties/{name}' with {name} not null nor empty";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        if (!this.ff4j.getPropertiesStore().existProperty(name)) {
            String errMsg = new FeatureNotFoundException(name).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        this.getPropertyStore().deleteProperty(name);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/update")
    @RolesAllowed(value={"WRITE"})
    @ApiOperation(value="Update a property", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Property has been updated"), @ApiResponse(code=404, message="Property not found"), @ApiResponse(code=400, message="Invalid new value")})
    public Response operationUpdate(@PathParam(value="name") String name, @PathParam(value="groupName") String newValue) {
        if (!this.ff4j.getPropertiesStore().existProperty(name)) {
            String errMsg = new FeatureNotFoundException(name).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        this.getPropertyStore().updateProperty(name, newValue);
        return Response.noContent().build();
    }
}

