/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.ff4j.core.Feature;
import org.ff4j.utils.json.FeatureJsonParser;
import org.ff4j.web.api.resources.AbstractResource;

@Produces(value={"application/json"})
@Path(value="/ff4j/store/groups/{groupName}")
@RolesAllowed(value={"READ"})
@Api(value="/ff4j/store/groups/{groupName}")
public class GroupResource
extends AbstractResource {
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Read information about a group", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Information about target group"), @ApiResponse(code=404, message="Group not found")})
    public Response read(@PathParam(value="groupName") String groupName) {
        Feature[] storeContent = this.getFeatureStore().readGroup(groupName).values().toArray(new Feature[0]);
        return Response.ok((Object)FeatureJsonParser.featureArrayToJson((Feature[])storeContent)).build();
    }

    @POST
    @Path(value="/enable")
    @RolesAllowed(value={"WRITE"})
    @ApiOperation(value="Enable a group", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Group has been updated")})
    public Response operationEnable(@PathParam(value="groupName") String groupName) {
        this.getFeatureStore().enableGroup(groupName);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/disable")
    @RolesAllowed(value={"WRITE"})
    @ApiOperation(value="Disable a group", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Group has been disabled")})
    public Response operationDisableGroup(@PathParam(value="groupName") String groupName) {
        this.getFeatureStore().disableGroup(groupName);
        return Response.noContent().build();
    }
}

