/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.ff4j.core.FlippingExecutionContext;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.security.AuthorizationsManager;
import org.ff4j.web.api.resources.AbstractResource;
import org.ff4j.web.api.resources.domain.AuthorizationsManagerApiBean;
import org.ff4j.web.api.resources.domain.FF4jStatusApiBean;
import org.ff4j.web.api.security.FF4JSecurityContextHolder;

@Path(value="/ff4j")
@Produces(value={"application/json"})
@RolesAllowed(value={"READ"})
@Api(value="/ff4j")
public class FF4jResource
extends AbstractResource {
    @GET
    @ApiOperation(value="Display <b>ff4j</b> status overview", notes="Display informations related to <b>Monitoring</b>, <b>Security</b>, <b>Cache</b> and <b>Store</b>")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, return status of ff4j instance", response=FF4jStatusApiBean.class)})
    @Produces(value={"application/json"})
    public FF4jStatusApiBean getStatus() {
        return new FF4jStatusApiBean(this.ff4j);
    }

    @GET
    @Path(value="/security")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display <b>Security</b> informations (permissions manager)", notes="Security is implemented through dedicated <b>AuthorizationsManager</b> but it's not mandatory")
    @ApiResponses(value={@ApiResponse(code=200, message="Status of current ff4j security bean", response=AuthorizationsManagerApiBean.class), @ApiResponse(code=404, message="No security defined, no response")})
    public Response getSecurityStatus() {
        AuthorizationsManager authMgner = this.ff4j.getAuthorizationsManager();
        if (null == authMgner) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No security has been defined").build();
        }
        return Response.ok((Object)new AuthorizationsManagerApiBean(authMgner)).build();
    }

    @GET
    @Path(value="/check/{uid}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="<b>Simple check</b> feature toggle", response=Boolean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="if feature is flipped"), @ApiResponse(code=400, message="Invalid parameter"), @ApiResponse(code=404, message="feature has not been found")})
    public Response check(@Context HttpHeaders headers, @PathParam(value="uid") String uid) {
        FF4JSecurityContextHolder.save(this.securityContext);
        if (!this.ff4j.getFeatureStore().exist(uid)) {
            String errMsg = new FeatureNotFoundException(uid).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        return Response.ok((Object)String.valueOf(this.ff4j.check(uid))).build();
    }

    @POST
    @Path(value="/check/{uid}")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="<b>Advanced check</b> feature toggle (parameterized)", response=Boolean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="if feature is flipped"), @ApiResponse(code=400, message="Invalid parameter")})
    public Response checkPOST(@Context HttpHeaders headers, @PathParam(value="uid") String uid, MultivaluedMap<String, String> formParams) {
        FF4JSecurityContextHolder.save(this.securityContext);
        if (!this.ff4j.getFeatureStore().exist(uid)) {
            String errMsg = new FeatureNotFoundException(uid).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        FlippingExecutionContext flipExecCtx = new FlippingExecutionContext();
        for (String key : formParams.keySet()) {
            flipExecCtx.putString(key, (String)formParams.getFirst((Object)key));
        }
        try {
            boolean flipped = this.ff4j.check(uid, flipExecCtx);
            return Response.ok((Object)String.valueOf(flipped)).build();
        }
        catch (IllegalArgumentException iae) {
            String errMsg = "Invalid parameter " + iae.getMessage();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @POST
    @Path(value="/check")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="<b>Check</b> multiple feature toggles", response=Boolean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Map of feature / flipped"), @ApiResponse(code=400, message="Invalid parameter")})
    public Response checkMulti(@Context HttpHeaders headers, @Context UriInfo uriInfo, Set<String> featureUIDs) {
        FF4JSecurityContextHolder.save(this.securityContext);
        HashMap<String, Boolean> featureFlippedMap = new HashMap<String, Boolean>();
        MultivaluedMap formParams = uriInfo.getQueryParameters();
        FlippingExecutionContext flipExecCtx = new FlippingExecutionContext();
        for (String key : formParams.keySet()) {
            flipExecCtx.putString(key, (String)formParams.getFirst((Object)key));
        }
        if (featureUIDs != null) {
            for (String featureUID : featureUIDs) {
                try {
                    featureFlippedMap.put(featureUID, this.ff4j.check(featureUID, flipExecCtx));
                }
                catch (FeatureNotFoundException e) {
                    featureFlippedMap.put(featureUID, false);
                }
            }
        }
        return Response.ok(featureFlippedMap).build();
    }
}

