/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.spi;

import com.jsoniter.spi.ClassInfo;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.GenericsHelper;
import com.jsoniter.spi.OmitValue;
import com.jsoniter.spi.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;

public class Binding {
    public final Class clazz;
    public final TypeLiteral clazzTypeLiteral;
    public Annotation[] annotations;
    public Field field;
    public Method method;
    public boolean valueCanReuse;
    public String name;
    public Type valueType;
    public TypeLiteral valueTypeLiteral;
    public String[] fromNames;
    public String[] toNames;
    public Decoder decoder;
    public Encoder encoder;
    public boolean asMissingWhenNotPresent;
    public boolean asExtraWhenPresent;
    public boolean isNullable = true;
    public boolean isCollectionValueNullable = true;
    public OmitValue defaultValueToOmit;
    public boolean shouldSkip;
    public int idx;
    public long mask;

    public Binding(ClassInfo classInfo, Map<String, Type> lookup, Type valueType) {
        this.clazz = classInfo.clazz;
        this.clazzTypeLiteral = TypeLiteral.create(classInfo.type);
        this.valueType = Binding.substituteTypeVariables(lookup, valueType);
        this.valueTypeLiteral = TypeLiteral.create(this.valueType);
    }

    public String decoderCacheKey() {
        return this.name + "@" + this.clazzTypeLiteral.getDecoderCacheKey();
    }

    public String encoderCacheKey() {
        return this.name + "@" + this.clazzTypeLiteral.getEncoderCacheKey();
    }

    private static Type substituteTypeVariables(Map<String, Type> lookup, Type type) {
        if (type instanceof TypeVariable) {
            return Binding.translateTypeVariable(lookup, (TypeVariable)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] args = pType.getActualTypeArguments();
            for (int i = 0; i < args.length; ++i) {
                args[i] = Binding.substituteTypeVariables(lookup, args[i]);
            }
            return GenericsHelper.createParameterizedType(args, pType.getOwnerType(), pType.getRawType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gaType = (GenericArrayType)type;
            Type componentType = Binding.substituteTypeVariables(lookup, gaType.getGenericComponentType());
            return GenericsHelper.createGenericArrayType(componentType);
        }
        return type;
    }

    private static Type translateTypeVariable(Map<String, Type> lookup, TypeVariable var) {
        Object declaredBy = var.getGenericDeclaration();
        if (!(declaredBy instanceof Class)) {
            return Object.class;
        }
        Class clazz = (Class)declaredBy;
        Type actualType = lookup.get(var.getName() + "@" + clazz.getCanonicalName());
        if (actualType == null) {
            return Object.class;
        }
        if (actualType instanceof TypeVariable) {
            return Binding.translateTypeVariable(lookup, (TypeVariable)actualType);
        }
        return actualType;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (this.annotations == null) {
            return null;
        }
        for (Annotation annotation : this.annotations) {
            if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binding binding = (Binding)o;
        if (this.clazz != null ? !this.clazz.equals(binding.clazz) : binding.clazz != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(binding.method) : binding.method != null) {
            return false;
        }
        return this.name != null ? this.name.equals(binding.name) : binding.name == null;
    }

    public int hashCode() {
        int result = this.clazz != null ? this.clazz.hashCode() : 0;
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Binding{clazz=" + this.clazz + ", name='" + this.name + '\'' + ", valueType=" + this.valueType + '}';
    }
}

