/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.test;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.faktorips.runtime.ClassloaderRuntimeRepository;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.test.AbstractIpsTestRunner;
import org.faktorips.runtime.test.IpsTest2;
import org.faktorips.runtime.test.IpsTestFailure;

public class CmdLineIpsTestRunner
extends AbstractIpsTestRunner {
    public CmdLineIpsTestRunner(String repositoryPackages) {
        this.setRepositoryPackages(repositoryPackages);
    }

    public static void main(String[] args) {
        CmdLineIpsTestRunner runner = new CmdLineIpsTestRunner(args[0]);
        try {
            runner.run(args[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected List<IRuntimeRepository> createRepositories() throws ParserConfigurationException {
        List<String> repositoryNameList = this.getRepositoryListFromInputString(this.getRepositoryPackages());
        ArrayList<IRuntimeRepository> runtimeRepositories = new ArrayList<IRuntimeRepository>(repositoryNameList.size());
        for (String repositoryName : repositoryNameList) {
            runtimeRepositories.add(ClassloaderRuntimeRepository.create(repositoryName, this.getClassLoader()));
        }
        return runtimeRepositories;
    }

    @Override
    public void testStarted(IpsTest2 test) {
        System.out.println("Test " + test.getQualifiedName() + " started.");
    }

    @Override
    public void testFinished(IpsTest2 test) {
        System.out.println("Test " + test.getQualifiedName() + " finished.");
    }

    @Override
    public void testFailureOccured(IpsTestFailure failure) {
        System.out.println("Test failed. Expected " + failure.getExpectedValue() + " but was " + failure.getActualValue());
    }
}

