/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type.read;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.model.type.read.SimpleGetterMethodAnnotationProcessor;
import org.faktorips.runtime.model.type.read.SimpleGetterMethodModelDescriptor;
import org.faktorips.runtime.model.type.read.SimpleTypePartsReader;
import org.faktorips.runtime.model.type.read.TypePartCollector;

class SimpleGetterMethodCollector<E extends ModelElement, P extends Annotation, C extends Annotation>
extends TypePartCollector<E, SimpleGetterMethodModelDescriptor<E>> {
    private Class<P> annotationClass;
    private SimpleTypePartsReader.NamesAccessor<P> namesAccessor;
    private SimpleTypePartsReader.ModelElementCreator<E> modelElementCreator;

    public SimpleGetterMethodCollector(Class<P> classAnnotationClass, SimpleTypePartsReader.NamesAccessor<P> namesAccessor, Class<C> getterAnnotationClass, SimpleTypePartsReader.NameAccessor<C> nameAccessor, SimpleTypePartsReader.ModelElementCreator<E> modelElementCreator) {
        super(Arrays.asList(new SimpleGetterMethodAnnotationProcessor(getterAnnotationClass, nameAccessor)));
        this.annotationClass = classAnnotationClass;
        this.namesAccessor = namesAccessor;
        this.modelElementCreator = modelElementCreator;
    }

    @Override
    protected String[] getNames(AnnotatedDeclaration annotatedDeclaration) {
        if (annotatedDeclaration.is(this.annotationClass)) {
            return this.namesAccessor.getNames(annotatedDeclaration.get(this.annotationClass));
        }
        return NO_NAMES;
    }

    @Override
    protected SimpleGetterMethodModelDescriptor<E> createDescriptor() {
        return new SimpleGetterMethodModelDescriptor<E>(this.modelElementCreator);
    }

    @Override
    public LinkedHashMap<String, E> createParts(ModelElement parentModel) {
        this.checkIfAllDeclaredNamesHaveCorrespondingMethod();
        return super.createParts(parentModel);
    }

    private void checkIfAllDeclaredNamesHaveCorrespondingMethod() {
        LinkedList<String> declaredButNoGetterFound = new LinkedList<String>();
        for (Map.Entry entry : this.getDescriptors().entrySet()) {
            if (((SimpleGetterMethodModelDescriptor)entry.getValue()).getGetterMethod() != null) continue;
            declaredButNoGetterFound.add(entry.getKey());
        }
        if (!declaredButNoGetterFound.isEmpty()) {
            String s = declaredButNoGetterFound.size() > 1 ? "s" : "";
            throw new IllegalStateException("No getter method" + s + " found for annotated part" + s + " \"" + IpsStringUtils.join(declaredButNoGetterFound, "\", \"") + "\"");
        }
    }
}

