/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.type.Association;
import org.faktorips.runtime.model.type.Attribute;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.model.type.TypeHierarchyVisitor;
import org.faktorips.runtime.util.MessagesHelper;

public abstract class Type
extends ModelElement {
    private final AnnotatedDeclaration annotatedDeclaration;
    private final MessagesHelper messagesHelper;

    public Type(String name, AnnotatedDeclaration annotatedDeclaration) {
        super(name, annotatedDeclaration.get(IpsExtensionProperties.class), Deprecation.of(annotatedDeclaration));
        this.annotatedDeclaration = annotatedDeclaration;
        IpsDocumented ipsDocumented = annotatedDeclaration.get(IpsDocumented.class);
        this.messagesHelper = this.createMessageHelper(ipsDocumented, annotatedDeclaration.getClassLoader());
    }

    protected abstract String getKindName();

    @Override
    protected String getMessageKey(DocumentationKind messageType) {
        return messageType.getKey(this.getName(), this.getKindName(), "");
    }

    @Override
    protected MessagesHelper getMessageHelper() {
        return this.messagesHelper;
    }

    public Association getDeclaredAssociation(int index) {
        return this.getDeclaredAssociations().get(index);
    }

    public Attribute getDeclaredAttribute(int index) {
        return this.getDeclaredAttributes().get(index);
    }

    public Association getAssociation(String name) {
        AssociationFinder finder = new AssociationFinder(name);
        finder.visitHierarchy(this);
        if (finder.association == null) {
            throw new IllegalArgumentException("The type " + this + " (or one of it's super types) hasn't got an association \"" + name + "\"");
        }
        return finder.association;
    }

    public Attribute getAttribute(String name) {
        AttributeFinder finder = new AttributeFinder(name);
        finder.visitHierarchy(this);
        if (finder.attribute == null) {
            throw new IllegalArgumentException("The type " + this + " (or one of it's supertypes) hasn't got an attribute \"" + name + "\"");
        }
        return finder.attribute;
    }

    protected AnnotatedDeclaration getAnnotatedDeclaration() {
        return this.annotatedDeclaration;
    }

    public Class<?> getJavaClass() {
        return this.annotatedDeclaration.getImplementationClass();
    }

    public Class<?> getJavaInterface() {
        return this.annotatedDeclaration.getPublishedInterface();
    }

    public Optional<Class<?>> findJavaInterface() {
        return Optional.ofNullable(this.getJavaInterface());
    }

    public Class<?> getDeclarationClass() {
        return this.getJavaInterface() == null ? this.getJavaClass() : this.getJavaInterface();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        this.findSuperType().ifPresent(s -> {
            sb.append(" extends ");
            sb.append(s.getName());
        });
        return sb.toString();
    }

    public <T extends Annotation> Method searchDeclaredMethod(Class<T> annotationClass, AnnotatedElementMatcher<T> matcher) {
        return this.findDeclaredMethod(annotationClass, matcher).orElse(null);
    }

    public <T extends Annotation> Optional<Method> findDeclaredMethod(Class<T> annotationClass, AnnotatedElementMatcher<T> matcher) {
        return this.getDeclaredMethods().stream().filter(method -> method.isAnnotationPresent(annotationClass) && matcher.matches(method.getAnnotation(annotationClass))).findFirst();
    }

    protected List<Method> getDeclaredMethods() {
        return this.getAnnotatedDeclaration().getDeclaredMethods();
    }

    public <T extends Annotation> Optional<Field> findDeclaredField(Class<T> annotationClass, AnnotatedElementMatcher<T> matcher) {
        return this.getDeclaredFields().stream().filter(field -> field.isAnnotationPresent(annotationClass) && matcher.matches(field.getAnnotation(annotationClass))).findFirst();
    }

    protected List<Field> getDeclaredFields() {
        return this.getAnnotatedDeclaration().getDeclaredFields();
    }

    public abstract List<? extends Association> getDeclaredAssociations();

    public abstract List<? extends Association> getAssociations();

    public abstract Association getDeclaredAssociation(String var1);

    public abstract boolean isAssociationDeclared(String var1);

    public boolean isAssociationPresent(String name) {
        AssociationFinder finder = new AssociationFinder(name);
        finder.visitHierarchy(this);
        return finder.association != null;
    }

    public abstract List<? extends Attribute> getDeclaredAttributes();

    public abstract boolean isAttributeDeclared(String var1);

    public boolean isAttributePresent(String name) {
        AttributeFinder finder = new AttributeFinder(name);
        finder.visitHierarchy(this);
        return finder.attribute != null;
    }

    public abstract List<? extends Attribute> getAttributes();

    public abstract Attribute getDeclaredAttribute(String var1);

    public boolean isSuperTypePresent() {
        return this.getSuperType() != null;
    }

    public abstract Type getSuperType();

    public Optional<? extends Type> findSuperType() {
        return Optional.ofNullable(this.getSuperType());
    }

    @FunctionalInterface
    public static interface AnnotatedElementMatcher<T extends Annotation> {
        public boolean matches(T var1);
    }

    static class AssociationFinder
    extends TypeHierarchyVisitor {
        private String associationName;
        private Association association = null;

        public AssociationFinder(String associationName) {
            this.associationName = IpsStringUtils.toLowerFirstChar(associationName);
        }

        @Override
        public boolean visitType(Type type) {
            boolean hasDeclaredAssociation = type.isAssociationDeclared(this.associationName);
            if (hasDeclaredAssociation) {
                this.association = type.getDeclaredAssociation(this.associationName);
            }
            return !hasDeclaredAssociation;
        }
    }

    static class AssociationsCollector<T extends Association>
    extends TypeHierarchyVisitor {
        private final List<T> result = new ArrayList<T>();
        private final Set<String> associationNames = new HashSet<String>();

        AssociationsCollector() {
        }

        @Override
        public boolean visitType(Type type) {
            for (Association association : type.getDeclaredAssociations()) {
                if (this.associationNames.contains(association.getName())) continue;
                this.associationNames.add(association.getName());
                Association castedAssociation = association;
                this.result.add(castedAssociation);
            }
            return true;
        }

        protected List<T> getResult() {
            return this.result;
        }
    }

    static class AttributeCollector<T extends Attribute>
    extends TypeHierarchyVisitor {
        private final List<T> result = new ArrayList<T>(30);
        private final Set<String> attributeNames = new HashSet<String>();

        AttributeCollector() {
        }

        @Override
        public boolean visitType(Type type) {
            for (Attribute attribute : type.getDeclaredAttributes()) {
                if (this.attributeNames.contains(attribute.getName())) continue;
                this.attributeNames.add(attribute.getName());
                Attribute castedAttribute = attribute;
                this.result.add(castedAttribute);
            }
            return true;
        }

        public List<T> getResult() {
            return this.result;
        }
    }

    static class AttributeFinder
    extends TypeHierarchyVisitor {
        private String attrName;
        private Attribute attribute = null;

        public AttributeFinder(String attrName) {
            this.attrName = IpsStringUtils.toLowerFirstChar(attrName);
        }

        @Override
        public boolean visitType(Type type) {
            boolean hasDeclaredAttribute = type.isAttributeDeclared(this.attrName);
            if (hasDeclaredAttribute) {
                this.attribute = type.getDeclaredAttribute(this.attrName);
            }
            return !hasDeclaredAttribute;
        }
    }
}

