/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.tableindex;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.faktorips.runtime.internal.tableindex.EmptySearchStructure;
import org.faktorips.runtime.internal.tableindex.MergeAndCopyStructure;
import org.faktorips.runtime.internal.tableindex.SearchStructure;

public abstract class AbstractMapStructure<K, V extends SearchStructure<R>, R>
extends SearchStructure<R> {
    private static final SearchStructure<?> EMPTY = new EmptySearchStructure();
    private final Map<K, V> map;

    protected AbstractMapStructure(Map<K, V> map) {
        this.map = map;
    }

    public void put(K key, V value) {
        if (this.getMap().containsKey(key)) {
            SearchStructure myValue = (SearchStructure)this.getMap().get(key);
            ((MergeAndCopyStructure)((Object)myValue)).merge(value);
        } else {
            this.getMap().put(key, value);
        }
    }

    protected void merge(AbstractMapStructure<K, V, R> otherMap) {
        Map<K, V> otherUnderlyingMap = otherMap.getMap();
        for (Map.Entry<K, V> entry : otherUnderlyingMap.entrySet()) {
            this.put(entry.getKey(), (SearchStructure)entry.getValue());
        }
    }

    protected <T extends AbstractMapStructure<K, V, R>> T fillCopy(T structure) {
        for (Map.Entry<K, V> entry : this.getMap().entrySet()) {
            SearchStructure value = (SearchStructure)((MergeAndCopyStructure)entry.getValue()).copy();
            structure.put(entry.getKey(), (SearchStructure)value);
        }
        return structure;
    }

    @Override
    public Set<R> get() {
        HashSet resultSet = new HashSet();
        for (SearchStructure value : this.getMap().values()) {
            Set set = value.get();
            resultSet.addAll(set);
        }
        return resultSet;
    }

    protected Map<K, V> getMap() {
        return this.map;
    }

    protected SearchStructure<R> getValidResult(V result) {
        if (result == null) {
            return this.emptyResult();
        }
        return result;
    }

    protected SearchStructure<R> emptyResult() {
        return EMPTY;
    }
}

