/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.faktorips.runtime.IRuntimeObject;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.internal.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RuntimeObject
implements IRuntimeObject {
    private Map<String, String> extPropertyValues = new HashMap<String, String>();

    protected void initExtensionPropertiesFromXml(Element cmptElement) {
        NodeList nl = cmptElement.getElementsByTagName("ExtensionProperties");
        if (nl == null || nl.getLength() == 0) {
            return;
        }
        nl = ((Element)nl.item(0)).getElementsByTagName("Value");
        int i = 0;
        while (i < nl.getLength()) {
            Element childElement = (Element)nl.item(i);
            String id = childElement.getAttribute("id");
            if (Boolean.parseBoolean(childElement.getAttribute("isNull"))) {
                this.extPropertyValues.put(id, null);
            } else {
                String value = XmlUtil.getCDATAorTextContent(childElement);
                this.extPropertyValues.put(id, value);
            }
            ++i;
        }
    }

    protected void writeExtensionPropertiesToXml(Element element) {
        this.writeExtensionPropertiesToXml(element, this.extPropertyValues);
    }

    protected void writeExtensionPropertiesToXml(Element element, Map<String, String> extPropertyMap) {
        Element extPropRootElement = null;
        if (!extPropertyMap.isEmpty()) {
            extPropRootElement = element.getOwnerDocument().createElement("ExtensionProperties");
            element.appendChild(extPropRootElement);
        }
        for (Map.Entry<String, String> extPropEntry : extPropertyMap.entrySet()) {
            Element extPropElement = ValueToXmlHelper.addValueAndReturnElement(extPropEntry.getValue(), extPropRootElement, "Value");
            extPropElement.setAttribute("id", extPropEntry.getKey());
        }
    }

    @Override
    public Set<String> getExtensionPropertyIds() {
        return this.extPropertyValues.keySet();
    }

    @Override
    public Object getExtensionPropertyValue(String propertyId) {
        return this.extPropertyValues.get(propertyId);
    }
}

