/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.HashMap;
import java.util.Map;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IObjectReferenceStore;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IUnresolvedReference;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.internal.XmlCallback;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractModelObject
implements IModelObject {
    public void removeChildModelObjectInternal(IModelObject child) {
    }

    @Override
    public MessageList validate(IValidationContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        MessageList list = new MessageList();
        this.validate(list, context);
        return list;
    }

    public void validate(MessageList list, IValidationContext context) {
        if (!this.validateSelf(list, context)) {
            return;
        }
        this.validateDependants(list, context);
    }

    protected void validateDependants(MessageList list, IValidationContext context) {
    }

    protected boolean validateSelf(MessageList list, IValidationContext context) {
        return true;
    }

    public void initFromXml(Element objectEl, boolean initWithProductDefaultsBeforeReadingXmlData, IRuntimeRepository productRepository, IObjectReferenceStore store) {
        this.initFromXml(objectEl, initWithProductDefaultsBeforeReadingXmlData, productRepository, store, null, null);
    }

    public void initFromXml(Element objectEl, boolean initWithProductDefaultsBeforeReadingXmlData, IRuntimeRepository productRepository, IObjectReferenceStore store, XmlCallback xmlCallback) {
        this.initFromXml(objectEl, initWithProductDefaultsBeforeReadingXmlData, productRepository, store, xmlCallback, "");
    }

    protected void initFromXml(Element objectEl, boolean initWithProductDefaultsBeforeReadingXmlData, IRuntimeRepository productRepository, IObjectReferenceStore store, XmlCallback xmlCallback, String currPath) {
        String pathFromAggregateRoot;
        String objectId = objectEl.getAttribute("objectId");
        if (store != null && objectId != null) {
            store.putObject(objectId, this);
        }
        NodeList nl = objectEl.getChildNodes();
        HashMap<String, String> propMap = this.createPropertiesMap(nl);
        this.initPropertiesFromXml(propMap, productRepository);
        String string = pathFromAggregateRoot = currPath == null ? null : String.valueOf(currPath) + "/" + objectEl.getNodeName();
        if (xmlCallback != null) {
            xmlCallback.initProperties(pathFromAggregateRoot, this, propMap);
        }
        this.initAssociations(initWithProductDefaultsBeforeReadingXmlData, productRepository, store, xmlCallback, objectId, nl, pathFromAggregateRoot);
    }

    private void initAssociations(boolean initWithProductDefaultsBeforeReadingXmlData, IRuntimeRepository productRepository, IObjectReferenceStore store, XmlCallback xmlCallback, String objectId, NodeList nl, String pathFromAggregateRoot) {
        int i = 0;
        int max = nl.getLength();
        while (i < max) {
            if (nl.item(i) instanceof Element) {
                Element el = (Element)nl.item(i);
                String type = el.getAttribute("type");
                if ("association".equals(type)) {
                    this.initAssociationFromXml(el, objectId, store);
                } else if ("composite".equals(type)) {
                    AbstractModelObject newChild = this.createChildFromXml(el);
                    if (newChild == null) {
                        throw new NullPointerException("Object: " + this + ", can't create child object, xml element: " + el);
                    }
                    newChild.initFromXml(el, initWithProductDefaultsBeforeReadingXmlData, productRepository, store, xmlCallback, pathFromAggregateRoot);
                } else if (!"property".equals(type)) {
                    throw new RuntimeException("Unknown type " + type);
                }
            }
            ++i;
        }
    }

    private HashMap<String, String> createPropertiesMap(NodeList nl) {
        HashMap<String, String> propMap = new HashMap<String, String>();
        int i = 0;
        int max = nl.getLength();
        while (i < max) {
            Element el;
            String type;
            if (nl.item(i) instanceof Element && "property".equals(type = (el = (Element)nl.item(i)).getAttribute("type"))) {
                this.putPropertyFromXml(el, propMap);
            }
            ++i;
        }
        return propMap;
    }

    private void putPropertyFromXml(Element el, HashMap<String, String> propMap) {
        String propName = el.getNodeName();
        propMap.put(propName, ValueToXmlHelper.getValueFromElement(el));
    }

    protected void initPropertiesFromXml(Map<String, String> propMap, IRuntimeRepository productRepository) {
    }

    protected AbstractModelObject createChildFromXml(Element childEl) {
        return null;
    }

    protected void initAssociationFromXml(Element el, Object objectId, IObjectReferenceStore store) {
        IUnresolvedReference reference;
        String targetRole = el.getNodeName();
        String targetId = el.getAttribute("targetId");
        try {
            reference = this.createUnresolvedReference(objectId, targetRole, targetId);
            if (reference == null) {
                throw new NullPointerException();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Object: " + this + ", cannot create unresolved reference for xml element " + el, e);
        }
        store.addUnresolvedReference(reference);
    }

    protected IUnresolvedReference createUnresolvedReference(Object objectId, String targetRole, String targetId) throws Exception {
        return null;
    }
}

