/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.util.concurrent.ConcurrentHashMap;
import org.faktorips.runtime.caching.IComputable;

public class SimpleCache
implements IComputable<Object, Object> {
    private final ConcurrentHashMap<Object, Object> objects;
    private final IComputable<Object, Object> computable;

    public SimpleCache(IComputable<Object, Object> computable) {
        this(computable, 16);
    }

    public SimpleCache(IComputable<Object, Object> computable, int initialCapacity) {
        this.computable = computable;
        this.objects = new ConcurrentHashMap(initialCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object compute(Object key) throws InterruptedException {
        Object result = this.objects.get(key);
        if (result != null) {
            return result;
        }
        SimpleCache simpleCache = this;
        synchronized (simpleCache) {
            result = this.objects.get(key);
            if (result != null) {
                return result;
            }
            result = this.computable.compute(key);
            if (result != null) {
                this.objects.put(key, result);
                return result;
            }
            return null;
        }
    }

    @Override
    public Class<? super Object> getValueClass() {
        return this.computable.getValueClass();
    }
}

