/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.tableindex;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.faktorips.values.ObjectUtil;

public enum RangeType {
    LOWER_BOUND{

        @Override
        public <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> tree, K key) {
            return this.findValue(tree, key).orElse(null);
        }

        @Override
        public <K extends Comparable<? super K>, V> Optional<V> findValue(TreeMap<K, V> tree, K key) {
            if (ObjectUtil.isNull(key)) {
                return Optional.empty();
            }
            Map.Entry<K, V> floorEntry = tree.floorEntry(key);
            if (floorEntry == null) {
                return Optional.empty();
            }
            return RangeType.getLowerValueIfNeccessary(tree, key, floorEntry);
        }
    }
    ,
    LOWER_BOUND_EQUAL{

        @Override
        public <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> tree, K key) {
            return this.findValue(tree, key).orElse(null);
        }

        @Override
        public <K extends Comparable<? super K>, V> Optional<V> findValue(TreeMap<K, V> tree, K key) {
            if (ObjectUtil.isNull(key)) {
                return Optional.empty();
            }
            Map.Entry<K, V> floorEntry = tree.floorEntry(key);
            return RangeType.getOptionalValue(floorEntry);
        }
    }
    ,
    UPPER_BOUND{

        @Override
        public <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> tree, K key) {
            return this.findValue(tree, key).orElse(null);
        }

        @Override
        public <K extends Comparable<? super K>, V> Optional<V> findValue(TreeMap<K, V> tree, K key) {
            if (ObjectUtil.isNull(key)) {
                return Optional.empty();
            }
            Map.Entry<K, V> ceilingEntry = tree.ceilingEntry(key);
            if (ceilingEntry == null) {
                return Optional.empty();
            }
            return RangeType.getHigherValueIfNeccessary(tree, key, ceilingEntry);
        }
    }
    ,
    UPPER_BOUND_EQUAL{

        @Override
        public <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> tree, K key) {
            return this.findValue(tree, key).orElse(null);
        }

        @Override
        public <K extends Comparable<? super K>, V> Optional<V> findValue(TreeMap<K, V> tree, K key) {
            if (ObjectUtil.isNull(key)) {
                return Optional.empty();
            }
            Map.Entry<K, V> ceilingEntry = tree.ceilingEntry(key);
            return RangeType.getOptionalValue(ceilingEntry);
        }
    };


    public abstract <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> var1, K var2);

    public abstract <K extends Comparable<? super K>, V> Optional<V> findValue(TreeMap<K, V> var1, K var2);

    private static <K extends Comparable<? super K>, V> Optional<V> getLowerValueIfNeccessary(TreeMap<K, V> tree, K key, Map.Entry<K, V> floorEntry) {
        if (((Comparable)floorEntry.getKey()).compareTo(key) < 0) {
            return Optional.ofNullable(floorEntry.getValue());
        }
        Map.Entry<Comparable, V> lowerEntry = tree.lowerEntry((Comparable)floorEntry.getKey());
        return RangeType.getOptionalValue(lowerEntry);
    }

    private static <K extends Comparable<? super K>, V> Optional<V> getHigherValueIfNeccessary(TreeMap<K, V> tree, K key, Map.Entry<K, V> ceilingEntry) {
        if (((Comparable)ceilingEntry.getKey()).compareTo(key) > 0) {
            return Optional.ofNullable(ceilingEntry.getValue());
        }
        Map.Entry<Comparable, V> higherEntry = tree.higherEntry((Comparable)ceilingEntry.getKey());
        return RangeType.getOptionalValue(higherEntry);
    }

    private static <K, V> Optional<V> getOptionalValue(Map.Entry<K, V> entry) {
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(entry.getValue());
    }
}

