/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

public class StringBuilderJoiner {
    public static final String DEFAULT_SEPARATOR = ", ";

    private StringBuilderJoiner() {
    }

    public static final void join(StringBuilder sb, Iterable<?> iterable, String separator) {
        StringBuilderJoiner.join(sb, iterable, separator, t -> sb.append(Objects.toString(t)));
    }

    public static final void join(StringBuilder sb, Iterable<?> iterable) {
        StringBuilderJoiner.join(sb, iterable, (? super T t) -> sb.append(Objects.toString(t)));
    }

    public static final void join(StringBuilder sb, Object[] objectArray) {
        StringBuilderJoiner.join(sb, Arrays.asList(objectArray));
    }

    public static final <T> void join(StringBuilder sb, Iterable<T> iterable, Consumer<? super T> singleItemAppender) {
        StringBuilderJoiner.join(sb, iterable, DEFAULT_SEPARATOR, singleItemAppender);
    }

    public static final <T> void join(StringBuilder sb, T[] objectArray, Consumer<? super T> singleItemAppender) {
        StringBuilderJoiner.join(sb, Arrays.asList(objectArray), singleItemAppender);
    }

    public static final <T> void join(StringBuilder sb, Iterable<T> iterable, String separator, Consumer<? super T> singleItemAppender) {
        Iterator<T> it;
        if (iterable != null && (it = iterable.iterator()) != null) {
            String sep;
            String string = sep = separator == null ? "" : separator;
            if (it.hasNext()) {
                singleItemAppender.accept(it.next());
            }
            while (it.hasNext()) {
                sb.append(sep);
                singleItemAppender.accept(it.next());
            }
        }
    }
}

