/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.jaxb;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.faktorips.runtime.internal.IpsStringUtils;

public class LocalDateTimeAdapter
extends XmlAdapter<String, LocalDateTime> {
    public LocalDateTime unmarshal(String v) {
        if (IpsStringUtils.isBlank(v)) {
            return null;
        }
        try {
            return LocalDateTime.parse(v);
        }
        catch (DateTimeParseException e) {
            LocalDateTime localDateTimeWithMilliseconds = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss:SSS").parse((CharSequence)v, LocalDateTime::from);
            return localDateTimeWithMilliseconds.withNano(0);
        }
    }

    public String marshal(LocalDateTime v) {
        if (v == null) {
            return null;
        }
        return v.toString();
    }
}

