/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import java.util.TimeZone;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TocEntry;
import org.w3c.dom.Element;

public class GenerationTocEntry
extends TocEntry {
    public static final String XML_TAG = "Generation";
    public static final String PROPERTY_VALID_FROM = "validFrom";
    private static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    private ProductCmptTocEntry parent;
    private DateTime validFrom;
    private long validFromAsLongInDefaultTimeZone;

    public GenerationTocEntry(ProductCmptTocEntry parent, DateTime validFrom, String className, String xmlResourceName) {
        super(className, xmlResourceName);
        this.parent = parent;
        this.validFrom = validFrom;
        this.validFromAsLongInDefaultTimeZone = validFrom.toDate(DEFAULT_TIME_ZONE).getTime();
    }

    public static final GenerationTocEntry createFromXml(ProductCmptTocEntry parent, Element element) {
        DateTime validFrom = DateTime.parseIso(element.getAttribute(PROPERTY_VALID_FROM));
        String className = element.getAttribute("implementationClass");
        String xmlResourceName = element.getAttribute("xmlResource");
        return new GenerationTocEntry(parent, validFrom, className, xmlResourceName);
    }

    @Override
    public String getXmlResourceName() {
        if (super.getXmlResourceName().equals("")) {
            return this.parent.getXmlResourceName();
        }
        return super.getXmlResourceName();
    }

    public ProductCmptTocEntry getParent() {
        return this.parent;
    }

    public DateTime getValidFrom() {
        return this.validFrom;
    }

    public final long getValidFromInMillisec(TimeZone zone) {
        if (zone.equals(DEFAULT_TIME_ZONE)) {
            return this.validFromAsLongInDefaultTimeZone;
        }
        return this.validFrom.toDate(zone).getTime();
    }

    @Override
    protected void addToXml(Element element) {
        super.addToXml(element);
        element.setAttribute(PROPERTY_VALID_FROM, this.validFrom.toIsoFormat());
    }

    public String toString() {
        return this.parent.toString() + " " + this.validFrom;
    }

    @Override
    protected String getXmlElementTag() {
        return XML_TAG;
    }
}

