/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.faktorips.runtime.util.StringBuilderJoiner;

public final class IpsStringUtils {
    public static final String EMPTY = "";

    private IpsStringUtils() {
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNotEmpty(String s) {
        return !IpsStringUtils.isEmpty(s);
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static boolean isNotBlank(String s) {
        return !IpsStringUtils.isBlank(s);
    }

    public static boolean trimEquals(String s1, String s2) {
        return Objects.equals(s1 != null ? s1.trim() : s1, s2 != null ? s2.trim() : s2);
    }

    public static String join(Collection<?> collection, String separator) {
        return IpsStringUtils.join(collection, separator);
    }

    public static String join(Iterable<?> iterable, String separator) {
        StringBuilder stringBuilder = new StringBuilder(256);
        StringBuilderJoiner.join(stringBuilder, iterable, separator, t -> stringBuilder.append(Objects.toString(t)));
        return stringBuilder.toString();
    }

    public static String join(Iterable<?> iterable) {
        return IpsStringUtils.join(iterable, ", ");
    }

    public static String join(Object[] objectArray) {
        return IpsStringUtils.join(Arrays.asList(objectArray));
    }

    public static String join(Object[] objectArray, String separator) {
        return IpsStringUtils.join(Arrays.asList(objectArray), separator);
    }

    public static <T> String join(Iterable<T> iterable, Function<? super T, String> toString) {
        StringBuilder stringBuilder = new StringBuilder(256);
        StringBuilderJoiner.join(stringBuilder, iterable, (? super T t) -> stringBuilder.append((String)toString.apply(t)));
        return stringBuilder.toString();
    }

    public static <T> String join(Iterable<T> iterable, Function<? super T, String> toString, String separator) {
        StringBuilder stringBuilder = new StringBuilder(256);
        StringBuilderJoiner.join(stringBuilder, iterable, separator, t -> stringBuilder.append((String)toString.apply(t)));
        return stringBuilder.toString();
    }

    public static String toLowerFirstChar(String string) {
        if (IpsStringUtils.isEmpty(string)) {
            return string;
        }
        char firstChar = string.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return string;
        }
        return Character.toLowerCase(firstChar) + string.substring(1);
    }
}

